package gov.va.med.mhv.mrp.web.controller;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portlet.PortletURLFactoryUtil;

@ManagedBean
@RequestScoped
public class GoalSamplesLinksController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(GoalSamplesController.class);

	public String getSampleURL(String goalId) {
		String url = "";
		
		try {
			PortletRequest portletRequest = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			ServiceContext serviceContext = ServiceContextFactory.getInstance(portletRequest);
			String portletId = serviceContext.getPortletId();
			long plid = serviceContext.getPlid();
			String lifecycle = PortletRequest.RENDER_PHASE;
						
			LiferayPortletURL portletURL = PortletURLFactoryUtil.create(portletRequest, portletId, plid, lifecycle);
			portletURL.setWindowState(WindowState.NORMAL);
			portletURL.setPortletMode(PortletMode.VIEW);
			portletURL.setParameter("_facesViewIdRender", "/views/samples/viewgoal.xhtml");
			portletURL.setParameter("goalId", goalId);
			
			url = portletURL.toString();
			
			url = url.replace("myGoalsSamplesLinks", "creategoal");
			
		} catch (Exception e) {
			log.debug(e);
		}
		
		return url;
	}

}
